# Gnuplot script file for plotting data in file "*.dat"
# This file is called   estilo.p

#=======================================================
#     Line wide point size and font aspects
#=======================================================
#
#     Specify the line wide and dot size

  linw=0.6
  poin=1
  fsize=14

#======================================================
#    Standard initialization to create the plot
#    some tags are for latin-american speakers
#======================================================

 set termopt enhanced         # Allows to put ^super/_{sub} indexes
 set   autoscale              # scale axes automatically
 set termoption dashed        # Allows dash styles
 unset log                    # remove any log-scaling
 unset label                  # remove any previous labels
 set xtic auto                # set xtics automatically
 set ytic auto                # set ytics automatically
 set encoding iso_8859_1      # Allow to put accents 
 set grid                     # Set the type of grid

#========================================================
#    KEYWORDS to control the PLOT LABELS
#========================================================
#    There are two ways to use the predertermine positions
#    or to indicate the x,y position using 
#    set key nobox at x, y

# set key outside box      #default inside the plot

#Para poner las leyendas en dif posiciones gnuplot utiliza
# top/bottom/center  left/right/center box/nobox
# set key center right box

#======================================================
#     SPECIFY PLOT RANGE
#======================================================

 set xr [-6 :8]
# set yr [-0.5:0.5]

#========================================================
#        PLOT INSIDE THE TOTAL CANVAS
#========================================================
#     Controls the position of the plot on the canvas
#     you can add extra "air" on the sides
#            l-> left t-> top r-> range

# set lmargin                          
# set tmargin 
# set rmargin
# set bmargin 5


#=======================================================
#   TITLES AND XY TIC LABELS
#=======================================================
#      You can modify the font and size but
#      is not necesary because you specify that on 
#      the outprint format

 set title  "GLOBAL TITLE"
 set xlabel "Bottom title"
 set ylabel "Ordinate coordinates" 

#=======================================================
#       Line Styles 
#=======================================================

 set style line 5  lt 1 lw linw pt 5  ps poin  lc rgb "navy"
 set style line 11 lt 2 lw linw pt 11 ps poin  lc rgb "red"
 set style line 10 lt 1 lw linw pt 10 ps poin  lc rgb "black" 


#======================================================
#      Add information and arrows to the plot
#======================================================

set label "(150,698)" at 20,10.05 font "Arial, 13"
set label "(julio)" at 20,9.9 font "Arial, 13"
#Arrow can be "nohead"
 set arrow from 19,10 to 24,10 


#======================================================
#           Fit data to equations 
#======================================================
#    
# f1(x)= m*x + b 
# b=0
# m=0
# fit f1(x) 'linear_data.dat' using 1:2 via m, b
# stats 'linear_data.dat' using 1:2 name 'fit'
# set label 1 sprintf("r = %1.6f",fit_correlation) at 21, 1.7




#======================================================
#          Output settings terminals
#=====================================================
#
#    Type of file you want to print the plot
#    eps is the most recomended 
#    Default: Shows it on your screen

#set term post eps size 7.00 cm ,4.00 cm enhanced "Times-Roman, 14"
#set output "outputfile.eps"



#=======================================================
#             Plot instructions
#=======================================================

#    filedatax.dat is your data file
#    using tag means which versus which column you are plotting
#    title mean the label title on the key box

plot     "ox_dos.dat" using 1:4 title 'O p' with lines ls 8, \
         "ox_dos.dat" using 1:5 title '' with lines ls 8, \
         "ti_dos.dat" using 1:6 title 'Ti d' with lines ls 5, \
         "ti_dos.dat" using 1:7 title '' with lines ls 5, \
         "DOS0" using 1:2 title 'Total' with lines ls 1, \
         "DOS0" using 1:3 title '' with lines ls 1;

#    "ti_dos.dat" using 1:6 title 'Ti d' with lines ls 5, \
#         "ti_dos.dat" using 1:7 title '' with lines ls 5, \
#         "ox_dos.dat" using 1:6 title 'O p' with lines ls 8, \
#         "ox_dos.dat" using 1:7 title '' with lines ls 8, \


 unset style line
 reset
